//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.4

import wesual.Ui     1.0
import wesual.Stage 1.0
import wesual.Util   1.0

Row {
    id : toggle

    property int orientation : setting.value

    Setting {
        id : setting

        domain : "OrientationToggle"
        key    : "orientation"
        defaultValue : 0
    }

    UiCheckButton {
        iconName  : "portrait"
        iconSize  : UiIcon.Icon_32x32
        bindable  : true
        checked   : setting.value === Portal.PortraitOrientation
        onClicked : setting.update(Portal.PortraitOrientation)
        tooltip   : qsTrId("0728ff07bee65605")
    }
    UiCheckButton {
        iconName  : "landscape"
        iconSize  : UiIcon.Icon_32x32
        bindable  : true
        checked   : setting.value === Portal.LandscapeOrientation
        onClicked : setting.update(Portal.LandscapeOrientation)
        tooltip   : qsTrId("b231b7514854890a")
    }
}
